// ------------------------------------
//       OnBoardC font Library
//            Version 1.0
//    by: Harry Konstas May.19/2000
// ------------------------------------
 
#include "OBL.h"
 
FONTFILE *LoadFont(CharPtr fname, int fID)
{

  LocalID id;
  FontPtr pData;
  FONTFILE *pFont;

  pFont=MemPtrNew(sizeof(FONTFILE));

  // Load font
  id=DmFindDatabase(0,fname);
  if(!id) return NULL;

  pFont->db=DmOpenDatabase(0,id,dmModeReadOnly);
  if(!pFont->db) return NULL;

  pFont->hFont=DmQueryRecord(pFont->db,0);
  pData=MemHandleLock(pFont->hFont);

  if(FntDefineFont(fID,pData)!=0) 
    return NULL;

  return pFont;

}

void DiscardFont(FONTFILE *pFont)
{

  if(!pFont->db) return;

  MemHandleUnlock(pFont->hFont);
  DmCloseDatabase(pFont->db);
  MemPtrFree(pFont);

}
